@ECHO OFF

REM *********************************
REM * NUGGET FIRMWARE UPDATE SCRIPT *
REM *********************************

SET UsbPath=USB HD
SET	TouchSettingsFile=\SD Card\Touch\Settings\user.json
SET ImageVersionCookieFile=imageversion.json
SET DeviceTypeCookieFile=deviceType.json
SET AutoRunPath=FlashDisk\AutoRun
SET ConfigDirectoryPath=FlashDisk\Nugget
SET CalibrationsPath=FlashDisk\Nugget\Calibrations

cd \%UsbPath%

REM Kill running firmware
NuggetUpdateHelper -kill
START NuggetUpdateHelper -solidOrange
NuggetUpdateHelper -delayOneSec
NuggetUpdateHelper -delayOneSec
NuggetUpdateHelper -kill
NuggetUpdateHelper -delayOneSec
NuggetUpdateHelper -delayOneSec

REM Ensure that device is WiFi Mode device
IF EXIST "%TouchSettingsFile%" GOTO DEVICEERROR
NuggetUpdateHelper -checkIsWifiModeDevice
IF ERRORLEVEL 2 GOTO DEVICEERROR 

REM Copy new firmware
DEL "\%AutoRunPath%\Nugget*.exe"
COPY "\%UsbPath%\NuggetFirmware*.exe" "\%AutoRunPath%\"

REM Configure registry
pregedit.exe -s "\USB HD\myReg.reg"
update.exe /fu

REM Copy image version cookie
MKDIR "\%ConfigDirectoryPath%"
COPY "\%UsbPath%\%ImageVersionCookieFile%" "\%ConfigDirectoryPath%\"

REM Copy device type cookie
MKDIR "\%ConfigDirectoryPath%"
COPY "\%UsbPath%\%DeviceTypeCookieFile%" "\%ConfigDirectoryPath%\"

REM Copy calibrations
MKDIR "\%CalibrationsPath%"
COPY "\%UsbPath%\Calibrations\*.*" "\%CalibrationsPath%\"

START NuggetUpdateHelper -blinkFastOrange
GOTO END

:DEVICEERROR
START NuggetUpdateHelper -blinkSlowOrange

:END