@ECHO OFF

REM Note: 
REM This Tool requires Update Tool V 6.0.1 or later
REM ################################################################################
REM Configuration Section

SET nuggetConfigPath=FlashDisk\Nugget\configuration.json
SET touchToolPath=USB HD\TouchTool.exe
SET settingsFolderPath=SD Card\Touch\Settings\
SET calibrationsFolderPath=SD Card\Touch\Calibrations\
SET calibrationsSourceFolderPath=USB HD\Calibrations\

REM If target device is a Colibri T20 and target image is V1.3 
REM or older set this to 1, otherwise set to 0
set isT20before1_4=0
set backupFolderPath=..\Backup
set imageConfigFilePath=FlashBackup.cfg
set updateToolPath=USB HD\UpdateTool\UpdateTool.exe

REM Configuration Section end
REM ################################################################################

ECHO ================================
ECHO = Accu-Gold Touch Updater v2.3 =
ECHO ================================
ECHO.

ECHO Validating target device...
IF EXIST "%nuggetConfigPath%" GOTO invalidDeviceError
ECHO OK

ECHO Activating display...
"%touchToolPath%" -displayOn > NUL
ECHO OK

ECHO Terminating running application...
"%touchToolPath%" -kill > NUL
"%touchToolPath%" -delayOneSec > NUL 
"%touchToolPath%" -delayOneSec > NUL
"%touchToolPath%" -delayOneSec > NUL
"%touchToolPath%" -delayOneSec > NUL
"%touchToolPath%" -delayOneSec > NUL
"%touchToolPath%" -kill > NUL
"%touchToolPath%" -delayOneSec > NUL
"%touchToolPath%" -delayOneSec > NUL
ECHO OK

ECHO Checking battery level...
"%touchToolPath%" -checkBatteryLevel > NUL
IF ERRORLEVEL 1 GOTO lowBatteryError
ECHO OK

ECHO Disabling power button...
"%touchToolPath%" -disablePowerOff > NUL
ECHO OK

ECHO Configuring settings...
MKDIR "%settingsFolderPath%" > NUL 2> NUL
ECHO OK

ECHO Deleting existing calibrations...
RMDIR /s /q "%calibrationsFolderPath%" > NUL 2> NUL
ECHO OK

ECHO Copying new calibrations...
MKDIR "%calibrationsFolderPath%" > NUL 2> NUL
COPY "%calibrationsSourceFolderPath%"* "%calibrationsFolderPath%" > NUL 2> NUL
ECHO OK

ECHO Updating image...
IF %isT20before1_4% == 0 "%updateToolPath%" /u %backupFolderPath%\%imageConfigFilePath%
IF %isT20before1_4% == 1 "%updateToolPath%" /u %backupFolderPath%\%imageConfigFilePath% /nandecc rs4
ECHO OK

ECHO ReEnabling power button...
"%touchToolPath%" -enablePowerOff > NUL
ECHO OK

ECHO Disabling shutdown delay...
"%touchToolPath%" -disableShutdownDelay > NUL
ECHO OK

ECHO.
ECHO Successfully updated firmware!
ECHO Please remove USB drive and restart device!
GOTO end

:invalidDeviceError
ECHO ERROR: Nugget device detected! Cannot apply Touch update!
GOTO endOfFile

:lowBatteryError
ECHO ERROR: Device's battery level is below 50%. Cannot start update!
ECHO Disabling shutdown delay...
"%touchToolPath%" -disableShutdownDelay > NUL
ECHO OK
ECHO Please restart and charge device and try again!


:end
PAUSE > NUL

:endOfFile